/* ================================================
   TAWK.TO LIVE CHAT - Hotel Noesis
   Include this file in all HTML pages before </body>
   ================================================ */

var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
  var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
  s1.async=true;
  // Replace YOUR_PROPERTY_ID and YOUR_WIDGET_ID with your actual Tawk.to IDs
  s1.src='https://embed.tawk.to/YOUR_PROPERTY_ID/YOUR_WIDGET_ID';
  s1.charset='UTF-8';
  s1.setAttribute('crossorigin','*');
  s0.parentNode.insertBefore(s1,s0);
})();

// ================================================
// Custom Configuration for Hotel Noesis
// ================================================

// When chat widget loads
Tawk_API.onLoad = function(){
  console.log('Hotel Noesis Chat: Ready');
  
  // Hide widget on very small screens initially (optional)
  if (window.innerWidth < 480) {
    // Tawk_API.hideWidget(); // Uncomment to hide on mobile by default
  }
};

// When chat is maximized (opened)
Tawk_API.onChatMaximized = function(){
  console.log('Hotel Noesis Chat: Opened');
  
  // You can trigger analytics events here
  if (typeof gtag !== 'undefined') {
    gtag('event', 'chat_opened', {
      'event_category': 'engagement',
      'event_label': 'Live Chat'
    });
  }
};

// When chat is minimized (closed)
Tawk_API.onChatMinimized = function(){
  console.log('Hotel Noesis Chat: Closed');
};

// When a message is sent by the visitor
Tawk_API.onChatMessageVisitor = function(message){
  console.log('Guest message sent');
  
  // Track message sent event
  if (typeof gtag !== 'undefined') {
    gtag('event', 'chat_message_sent', {
      'event_category': 'engagement',
      'event_label': 'Guest Message'
    });
  }
};

// When a message is received from agent
Tawk_API.onChatMessageAgent = function(message){
  console.log('Agent response received');
};

// Set custom attributes based on page
Tawk_API.onLoad = function(){
  var currentPage = window.location.pathname.split('/').pop().replace('.html', '') || 'home';
  var pageNames = {
    'index': 'Homepage',
    'stay': 'Accommodations',
    'eats': 'Dining Overview',
    'ntangaza': 'Ntangaza Restaurant',
    'solari': 'Solari Terrace & Sky Bar',
    'grove-pit': 'The Grove Pit',
    'wellness': 'Wellness & Spa',
    'services': 'Services',
    'travel-info': 'Travel Information',
    'contact': 'Contact',
    'bookings': 'Bookings',
    'terms': 'Terms & Conditions'
  };
  
  Tawk_API.setAttributes({
    'Current Page': pageNames[currentPage] || currentPage,
    'Visit Date': new Date().toLocaleDateString(),
    'Device': window.innerWidth < 768 ? 'Mobile' : 'Desktop'
  }, function(error){
    if(error) {
      console.log('Error setting attributes:', error);
    }
  });
};

// Optional: Add visitor information if you have it
// For example, from a booking form or user login
function updateChatVisitor(name, email, phone) {
  if (typeof Tawk_API !== 'undefined' && Tawk_API.setAttributes) {
    Tawk_API.setAttributes({
      'name': name,
      'email': email,
      'phone': phone
    }, function(error){
      if(error) {
        console.log('Error updating visitor info:', error);
      }
    });
  }
}

// Optional: Show chat programmatically
function openNoesisChat() {
  if (typeof Tawk_API !== 'undefined' && Tawk_API.maximize) {
    Tawk_API.maximize();
  }
}

// Optional: Hide chat programmatically
function closeNoesisChat() {
  if (typeof Tawk_API !== 'undefined' && Tawk_API.minimize) {
    Tawk_API.minimize();
  }
}
